@extends('layouts.app')

@section('title', 'Payment Successful')

@section('content')
<div class="store-container">
    <div class="container">
        <div class="store-result success-page">
            <!-- Success Animation -->
            <div class="success-animation">
                <div class="checkmark-container">
                    <i class="checkmark-check fa fa-check fa-2x"></i>
                </div>
            </div>

            <!-- Success Content -->
            <div class="success-content">
                <h2 class="success-title">Payment Successful!</h2>
                <p class="success-subtitle">
                    Thank you for your purchase! Your {{ $transaction->package->name }} package has been successfully processed.
                </p>

                <!-- Purchase Summary Card -->
                <div class="purchase-summary">
                    <div class="summary-header">
                        <h3>Purchase Summary</h3>
                        <div class="status-badge success">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                <path d="M10.97 4.97a.235.235 0 0 0-.02.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.061L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-1.071-1.05z"/>
                                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                            </svg>
                            Completed
                        </div>
                    </div>

                    <div class="summary-content">
                        <div class="package-info">
                            <div class="package-icon">
                                @switch($transaction->package->type)
                                    @case('vip')
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                                            <path d="M5.354 4.646a.5.5 0 1 0-.708.708L7.293 8l-2.647 2.646a.5.5 0 0 0 .708.708L8 8.707l2.646 2.647a.5.5 0 0 0 .708-.708L8.707 8l2.647-2.646a.5.5 0 0 0-.708-.708L8 7.293 5.354 4.646z"/>
                                        </svg>
                                        @break
                                    @case('money')
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 10a2 2 0 1 0 0-4 2 2 0 0 0 0 4z"/>
                                            <path d="M0 4a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H1a1 1 0 0 1-1-1V4zm3 0a2 2 0 0 1-2 2v4a2 2 0 0 1 2 2h10a2 2 0 0 1 2-2V6a2 2 0 0 1-2-2H3z"/>
                                        </svg>
                                        @break
                                    @case('job')
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8.5 1.5A1.5 1.5 0 0 1 10 0h4a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h4a1.5 1.5 0 0 1 1.5 1.5v1H8a.5.5 0 0 0 0 1h.5v1H8a.5.5 0 0 0 0 1h.5v1H8a.5.5 0 0 0 0 1h.5v1H8a.5.5 0 0 0 0 1h.5v1H8a.5.5 0 0 0 0 1h.5v1H8a.5.5 0 0 0 0 1h.5v1H8a.5.5 0 0 0 0 1h.5v1a1.5 1.5 0 0 1-1.5 1.5H2a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h4a.5.5 0 0 0 .5-.5z"/>
                                        </svg>
                                        @break
                                    @default
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492zM5.754 8a2.246 2.246 0 1 1 4.492 0 2.246 2.246 0 0 1-4.492 0z"/>
                                            <path d="M9.796 1.343c-.527-1.79-3.065-1.79-3.592 0l-.094.319a.873.873 0 0 1-1.255.52l-.292-.16c-1.64-.892-3.433.902-2.54 2.541l.159.292a.873.873 0 0 1-.52 1.255l-.319.094c-1.79.527-1.79 3.065 0 3.592l.319.094a.873.873 0 0 1 .52 1.255l-.16.292c-.892 1.64.901 3.434 2.541 2.54l.292-.159a.873.873 0 0 1 1.255.52l.094.319c.527 1.79 3.065 1.79 3.592 0l.094-.319a.873.873 0 0 1 1.255-.52l.292.16c1.64.893 3.434-.902 2.54-2.541l-.159-.292a.873.873 0 0 1 .52-1.255l.319-.094c1.79-.527 1.79-3.065 0-3.592l-.319-.094a.873.873 0 0 1-.52-1.255l.16-.292c.893-1.64-.902-3.433-2.541-2.54l-.292.159a.873.873 0 0 1-1.255-.52l-.094-.319z"/>
                                        </svg>
                                @endswitch
                            </div>
                            <div class="package-details">
                                <h4>{{ $transaction->package->name }}</h4>
                                <p>{{ $transaction->package->description }}</p>
                            </div>
                        </div>

                        <div class="transaction-grid">
                            <div class="transaction-item">
                                <span class="label">Transaction ID</span>
                                <span class="value">{{ $transaction->transaction_id ?? $transaction->uuid }}</span>
                                <button class="copy-btn" onclick="copyToClipboard('{{ $transaction->transaction_id ?? $transaction->uuid }}')">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1v-1z"/>
                                        <path d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5h3zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3z"/>
                                    </svg>
                                </button>
                            </div>

                            @if($transaction->server)
                            <div class="transaction-item">
                                <span class="label">Server</span>
                                <span class="value">{{ $transaction->server->name }}</span>
                            </div>
                            @endif

                            <div class="transaction-item">
                                <span class="label">Payment Method</span>
                                <span class="value payment-method">
                                    @if($transaction->payment_method === 'stripe')
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm2 3.5A1.5 1.5 0 0 1 5.5 2h5A1.5 1.5 0 0 1 12 3.5v1A1.5 1.5 0 0 1 10.5 6h-5A1.5 1.5 0 0 1 4 4.5v-1zM5.5 3a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h5a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-5z"/>
                                        </svg>
                                        Credit/Debit Card
                                    @else
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M14.06 3.713c.12-1.071-.093-1.832-.702-2.526C12.628.356 11.312 0 9.626 0H4.734a.7.7 0 0 0-.691.59L2.005 13.509a.42.42 0 0 0 .415.486h2.756l-.202 1.28a.628.628 0 0 0 .62.726H8.14c.429 0 .793-.31.862-.731l.025-.13.48-3.043.016-.102.106-.1c.121-.124.328-.196.517-.196h.75c2.1 0 3.76-.48 4.244-1.871.164-.474.26-.94.28-1.372.12-1.244-.254-2.103-1.01-2.763-.32-.284-.71-.45-1.128-.571z"/>
                                        </svg>
                                        PayPal
                                    @endif
                                </span>
                            </div>

                            @if($transaction->discount_amount > 0)
                            <div class="transaction-item discount">
                                <span class="label">Original Price</span>
                                <span class="value original">{{ currency_symbol(config_value('store_currency', 'GBP')) }}{{ number_format($transaction->original_amount, 2) }}</span>
                            </div>
                            <div class="transaction-item discount">
                                <span class="label">Discount Applied</span>
                                <span class="value savings">-{{ currency_symbol(config_value('store_currency', 'GBP')) }}{{ number_format($transaction->discount_amount, 2) }} ({{ $transaction->discount_percentage }}%)</span>
                            </div>
                            @endif

                            <div class="transaction-item total">
                                <span class="label">Total Paid</span>
                                <span class="value amount">{{ currency_symbol(config_value('store_currency', 'GBP')) }}{{ number_format($transaction->amount, 2) }}</span>
                            </div>

                            <div class="transaction-item">
                                <span class="label">Date & Time</span>
                                <span class="value">{{ $transaction->created_at->format('M d, Y \a\t H:i') }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Next Steps -->
                <div class="next-steps">
                    <div class="steps-header">
                        <h3>What happens next?</h3>
                    </div>
                    <div class="steps-list">
                        <div class="step">
                            <div class="step-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492zM5.754 8a2.246 2.246 0 1 1 4.492 0 2.246 2.246 0 0 1-4.492 0z"/>
                                    <path d="M9.796 1.343c-.527-1.79-3.065-1.79-3.592 0l-.094.319a.873.873 0 0 1-1.255.52l-.292-.16c-1.64-.892-3.433.902-2.54 2.541l.159.292a.873.873 0 0 1-.52 1.255l-.319.094c-1.79.527-1.79 3.065 0 3.592l.319.094a.873.873 0 0 1 .52 1.255l-.16.292c-.892 1.64.901 3.434 2.541 2.54l.292-.159a.873.873 0 0 1 1.255.52l.094.319c.527 1.79 3.065 1.79 3.592 0l.094-.319a.873.873 0 0 1 1.255-.52l.292.16c1.64.893 3.434-.902 2.54-2.541l-.159-.292a.873.873 0 0 1 .52-1.255l.319-.094c1.79-.527 1.79-3.065 0-3.592l-.319-.094a.873.873 0 0 1-.52-1.255l.16-.292c.893-1.64-.902-3.433-2.541-2.54l-.292.159a.873.873 0 0 1-1.255-.52l-.094-.319z"/>
                                </svg>
                            </div>
                            <div class="step-content">
                                <h4>Processing Complete</h4>
                                <p>Your purchase has been successfully processed and recorded</p>
                            </div>
                        </div>
                        <div class="step">
                            <div class="step-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M15.964.686a.5.5 0 0 0-.65-.65L.767 5.855H.766l-.452.18a.5.5 0 0 0-.082.887l.41.26.001.002 4.995 3.178 3.178 4.995.002.002.26.41a.5.5 0 0 0 .886-.083l6-15Zm-1.833 1.89L6.637 10.07l-.215-.338a.5.5 0 0 0-.154-.154l-.338-.215 7.494-7.494 1.178-.471-.47 1.178Z"/>
                                </svg>
                            </div>
                            <div class="step-content">
                                <h4>Benefits Applied</h4>
                                <p>Your in-game benefits will be available within 5-10 minutes</p>
                            </div>
                        </div>
                        <div class="step">
                            <div class="step-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 1a2.5 2.5 0 0 1 2.5 2.5V4h-5v-.5A2.5 2.5 0 0 1 8 1zm3.5 3v-.5a3.5 3.5 0 1 0-7 0V4H1v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4h-3.5zM2 5h12v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V5z"/>
                                </svg>
                            </div>
                            <div class="step-content">
                                <h4>Ready to Play</h4>
                                <p>Join the server and enjoy your new benefits!</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="action-buttons">
                    <a href="{{ route('store.index') }}" class="btn btn-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .491.592l-1.5 8A.5.5 0 0 1 13 12H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5zM3.102 4l1.313 7h8.17l1.313-7H3.102zM5 12a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm7 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm-7 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm7 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>
                        </svg>
                        Browse More Items
                    </a>
                    <a href="{{ route('home') }}" class="btn btn-secondary">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z"/>
                        </svg>
                        Home Page
                    </a>
                </div>

                <!-- Help Section -->
                <div class="help-section">
                    <p class="help-text">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                            <path d="m8.93 6.588-2.29.287-.082.38.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246-.275 0-.375-.193-.304-.533L8.93 6.588zM9 4.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0z"/>
                        </svg>
                        Need help? Contact our support team if you don't receive your benefits within 15 minutes.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="copy-notification" class="copy-notification">
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
        <path d="M10.97 4.97a.235.235 0 0 0-.02.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.061L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-1.071-1.05z"/>
    </svg>
    Copied to clipboard!
</div>
@endsection

@push('scripts')
<script>
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(function() {
            // Show notification
            const notification = document.getElementById('copy-notification');
            notification.classList.add('show');
            
            // Hide after 2 seconds
            setTimeout(() => {
                notification.classList.remove('show');
            }, 2000);
        }).catch(function(err) {
            console.error('Could not copy text: ', err);
        });
    }

    // Add some entrance animations
    document.addEventListener('DOMContentLoaded', function() {
        // Animate elements in sequence
        setTimeout(() => {
            document.querySelector('.checkmark-container').classList.add('animate');
        }, 100);
        
        setTimeout(() => {
            document.querySelector('.success-content').classList.add('fade-in');
        }, 600);
    });
</script>
@endpush